//AIM:N=8; IDIT-FFT without using inbuilt Scilab FFT function
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
//Let X(k)={11,1-1,1,-5,1,-1,1} 
//Let us begin with the programming.For understanding,let us write the given data as
//X(0)=11;X(1)=1,X(2)=-1,X(3)=1,X(4)=-5,X(5)=1,X(6)=-1,X(7)=1
X0_conj=11;//IDIT-FFT,so arranging the input in bit-reversed order
X4_conj=-5;//IDIT-FFT,so arranging the input in bit-reversed order
X2_conj=-1;//IDIT-FFT,so arranging the input in bit-reversed order
X6_conj=-1;//IDIT-FFT,so arranging the input in bit-reversed order
X1_conj=1;//IDIT-FFT,so arranging the input in bit-reversed order
X5_conj=1;//IDIT-FFT,so arranging the input in bit-reversed order
X3_conj=1;//IDIT-FFT,so arranging the input in bit-reversed order
X7_conj=1;//IDIT-FFT,so arranging the input in bit-reversed order
disp(X0_conj,'X*(0)=')
disp(X4_conj,'X*(4)=')
disp(X2_conj,'X*(2)=')
disp(X6_conj,'X*(6)=')
disp(X1_conj,'X*(1)=')
disp(X5_conj,'X*(5)=')
disp(X3_conj,'X*(3)=')
disp(X7_conj,'X*(7)=')
//Stage I computation
X0a=X4_conj+X0_conj;//Computing Stage-I output at line 1
disp(X0a,'Stage-I output at line 1=')
X4b=(X4_conj-X0_conj)*(-1);//Computing Stage-I output at line 2
disp(X4b,'Stage-I output at line 2=')
X2c=X6_conj+X2_conj;//Computing Stage-I output at line 3
disp(X2c,'Stage-I output at line 3=')
X6d=(X6_conj-X2_conj)*(-1);//Computing Stage-I output at line 4
disp(X6d,'Stage-I output at line 4=')
X1e=X5_conj+X1_conj;//Computing Stage-I output at line 5
disp(X1e,'Stage-I output at line 5=')
X5f=(X5_conj-X1_conj)*(-1);//Computing Stage-I output at line 6
disp(X5f,'Stage-I output at line 6=')
X3g=X7_conj+X3_conj;//Computing Stage-I output at line 7
disp(X3g,'Stage-I output at line 7')
X7h=(X7_conj-X3_conj)*(-1);//Computing Stage-I output at line 8
disp(X7h,'Stage-I output at line 8=')

//Stage-I output at line 4 and line 8 is to be multiplied by twiddle factor having value (-j)
X6d'=(X6d)*(-sqrt(-1));
X7h'=(X7h)*(-sqrt(-1));
disp(X6d','Stage-I output(i.e. input to stage-II)after multiplication by twiddle factor value of (-j) at line 4 =')
disp(X7h','Stage-I output(i.e. input to stage-II)after multiplication by twiddle factor value of (-j) at line 8 =')

//Stage-II Computations
X0a_stageII_output=X2c+X0a;//Computing Stage-II output at line 1
disp(X0a_stageII_output,'Stage-II output at line 1=')
X4b_stageII_output=X6d'+X4b;//Computing Stage-II output at line 2
disp(X4b_stageII_output,'Stage-II output at line 2=')
X2c_stageII_output=(X2c-X0a)*(-1);//Computing Stage-II output at line 3
disp(X2c_stageII_output,'Stage-II output at line 3=')
X6d_stageII_output=(X6d'-X4b)*(-1);//Computing Stage-II output at line 4
disp(X6d_stageII_output,'Stage-II output at line 4=')
X1e_stageII_output=X3g+X1e;//Computing Stage-II output at line 5
disp(X1e_stageII_output,'Stage-II output at line 5=')
X5f_stageII_output=X7h'+X5f;//Computing Stage-II output at line 6
disp(X5f_stageII_output,'Stage-II output at line 6=')
X3g_stageII_output=(X3g-X1e)*(-1);//Computing Stage-II output at line 7
disp(X3g_stageII_output,'Stage-II output at line 7=')
X7h_stageII_output=(X7h'-X5f)*(-1);//Computing Stage-II output at line 8
disp(X7h_stageII_output,'Stage-II output at line 8=')

//Stage-II output at line 6,line 7 and line 8 are to be multiplied by twiddle factor having value (0.707-j0.707),(-j) and (-0.707-j0.707) respectively
X5f_stageII_output_multiplied_by_twiddle=(X5f_stageII_output)*(0.707-(sqrt(-1))*(0.707));
disp(X5f_stageII_output_multiplied_by_twiddle,'Stage-II output at line 6 after multiplication by twiddle factor=')
X3g_stageII_output_multiplied_by_twiddle=(X3g_stageII_output)*(-(sqrt(-1)));
disp(X3g_stageII_output_multiplied_by_twiddle,'Stage-II output at line 7 after multiplication by twiddle factor=')
X7h_stageII_output_multiplied_by_twiddle=(X7h_stageII_output)*(-0.707-(sqrt(-1))*(0.707));
disp(X7h_stageII_output_multiplied_by_twiddle,'Stage-II output at line 8 after multiplication by twiddle factor=')

//Stage-III Computations(i.e. Computations for the final stage)
x0_star=(1/8)*(X1e_stageII_output+X0a_stageII_output);//Computing x*(0) at last stage
x1_star=(1/8)*(X5f_stageII_output_multiplied_by_twiddle+X4b_stageII_output);//Computing x*(1) at last stage
x2_star=(1/8)*(X3g_stageII_output_multiplied_by_twiddle+X2c_stageII_output);//Computing x*(2) at last stage
x3_star=(1/8)*(X7h_stageII_output_multiplied_by_twiddle+X6d_stageII_output);//Computing x*(3) at last stage
x4_star=(1/8)*((X1e_stageII_output-X0a_stageII_output)*(-1));//Computing x*(4) at last stage
x5_star=(1/8)*((X5f_stageII_output_multiplied_by_twiddle-X4b_stageII_output)*(-1));//Computing x*(5) at last stage
x6_star=(1/8)*((X3g_stageII_output_multiplied_by_twiddle-X2c_stageII_output)*(-1));//Computing x*(6) at last stage
x7_star=(1/8)*((X7h_stageII_output_multiplied_by_twiddle-X6d_stageII_output)*(-1));//Computing x*(7) at last stage
disp(x0_star,'x*(0)=')
disp(x1_star,'x*(1)=')
disp(x2_star,'x*(2)=')
disp(x3_star,'x*(3)=')
disp(x4_star,'x*(4)=')
disp(x5_star,'x*(5)=')
disp(x6_star,'x*(6)=')
disp(x7_star,'x*(7)=')
disp({,x0_star,x1_star,x2_star,x3_star,x4_star,x5_star,x6_star,x7_star,},'x*(n)=')
x0_star_real=real(x0_star);
x0_star_imag_conj=(-1)*(imag(x0_star));
x1_star_real=real(x1_star);
x1_star_imag_conj=(-1)*(imag(x1_star));
x2_star_real=real(x2_star);
x2_star_imag_conj=(-1)*(imag(x2_star));
x3_star_real=real(x3_star);
x3_star_imag_conj=(-1)*(imag(x3_star));
x4_star_real=real(x4_star);
x4_star_imag_conj=(-1)*(imag(x4_star));
x5_star_real=real(x5_star);
x5_star_imag_conj=(-1)*(imag(x5_star));
x6_star_real=real(x6_star);
x6_star_imag_conj=(-1)*(imag(x6_star));
x7_star_real=real(x7_star);
x7_star_imag_conj=(-1)*(imag(x7_star));
x0=x0_star_real+x0_star_imag_conj;
x1=x1_star_real+x1_star_imag_conj;
x2=x2_star_real+x2_star_imag_conj;
x3=x3_star_real+x3_star_imag_conj;
x4=x4_star_real+x4_star_imag_conj;
x5=x5_star_real+x5_star_imag_conj;
x6=x6_star_real+x6_star_imag_conj;
x7=x7_star_real+x7_star_imag_conj;
disp({,x0,x1,x2,x3,x4,x5,x6,x7,},'So,the IDFT of X(k) using Inverse Decimation-in-Time Fast Fourier Transform(IDIT-FFT) is x(n)=')
